/*******************************************************************/
/*          VS1003 driver for  Mega32 MP3 Player                   */
/*                                                                 */
/* Platform   : AVRStudio4.13 b528 + WinAVR20070122                */
/*              optimize -0s                                       */
/* Author     : bozai(Zhang Qibo)                                  */
/* E-mail     : sudazqb@163.com                                    */
/* MSN        : zhangqibo_1985@hotmail.com                         */
/* Date       : 2006-05-09                                         */
/*******************************************************************/

#include <avr/io.h>
#include "VS1003B.h"
#include <util/delay.h>
//#define F_CPU 8000000UL


#define uchar unsigned char
#define uint  unsigned int

//low speed
void VS1003B_SPI_Low(void)
{
	SPCR =   _BV(SPE)|_BV(MSTR)|_BV(SPR1)|_BV(SPR0);
	SPSR &= ~_BV(SPI2X);
}

//full speed
void VS1003B_SPI_High(void)
{
	SPCR =  _BV(SPE)|_BV(MSTR);
	//SPSR &= ~_BV(SPI2X);
	SPSR |= _BV(SPI2X);
}

//delay
void VS1003B_Delay( unsigned int n)
{
	while(n--)asm("nop");
}

//write one byte to vs1003
unsigned char VS1003B_WriteByte(unsigned char CH)
{   
	SPDR = CH;
	while(!(SPSR & _BV(SPIF)));
	return SPDR;
}

//read one byte from vs1003
unsigned char VS1003B_ReadByte(void)
{
    SPDR = 0xff;
	while(!(SPSR & _BV(SPIF)));
	return SPDR;
}

//config register
void VS1003B_WriteCMD(unsigned char addr, unsigned int dat)
{
	VS1003B_XDCS_H();
	VS1003B_XCS_L();
	VS1003B_WriteByte(0x02);
	VS1003B_WriteByte(addr);
	VS1003B_WriteByte(dat>>8);
	VS1003B_WriteByte(dat);
	VS1003B_XCS_H();
}

//read register
unsigned int VS1003B_ReadCMD(unsigned char addr)
{
	unsigned int temp;
	VS1003B_XDCS_H();
	VS1003B_XCS_L();
	VS1003B_WriteByte(0x03);
	VS1003B_WriteByte(addr);
	temp = VS1003B_ReadByte();
	temp <<= 8;
	temp += VS1003B_ReadByte();
	VS1003B_XCS_H();
	return temp;
}

//write data (music data)
void VS1003B_WriteDAT(unsigned char dat)
{
	VS1003B_XDCS_L();
	VS1003B_WriteByte(dat);
	VS1003B_XDCS_H();
	VS1003B_XCS_H();
}

// 1 means fail, 0 OK!
unsigned char VS1003B_Init(void)
{
	unsigned char retry;
	PORT_INI();
	VS1003B_DDR &=~_BV(VS1003B_DREQ);
	VS1003B_XCS_H();
	VS1003B_XDCS_H();
	VS1003B_XRESET_L();
	_delay_ms(20);
	VS1003B_XRESET_H();	//chip select
	VS1003B_SPI_Low();	//low speed
	_delay_ms(20);		//delay

	retry=0;

	while(VS1003B_ReadCMD(0x03) != CLOCK_REG)		//set PLL register
	{
		VS1003B_WriteCMD(0x03,CLOCK_REG);
		if(retry++ >10 )return 1;
	}

	_delay_ms(20);
	
	VS1003B_WriteCMD(0x05,0x000a);
	
	retry=0;
	while(VS1003B_ReadCMD(0x0b) != 0xfefe)			//set Volume
	{
		VS1003B_WriteCMD(0x0b,0xfefe);
		if(retry++ >10 )return 1;
	}

	VS1003B_WriteCMD(0x05,0xac45);

	retry=0;
	while(VS1003B_ReadCMD(0x0b) != DefaultVolume)	//set Volume
	{
		VS1003B_WriteCMD(0x0b,DefaultVolume);
		if(retry++ >10 )return 1;
	}

	retry=0;
	while(VS1003B_ReadCMD(0x00) != 0x0800)			//set mode register
	{
		VS1003B_WriteCMD(0x00,0x0800);
		if(retry++ >10 )return 1;
	}

	_delay_ms(20);

	VS1003B_SoftReset();

	_delay_ms(20);

	VS1003B_SPI_High();
	return 0;
}

//VS1003 soft reset
void VS1003B_SoftReset(void)
{
	VS1003B_WriteCMD(0x00,0x0804);//reset
//	VS1003B_Delay(0xffff);//wait at least 1.35ms
	_delay_ms(20);
}


